# Image classification

We explore the classification of images from the CIFAR-10 dataset using:

k-Nearest Neighbors (k-NN): A simple and interpretable instance-based learning algorithm.
Multi-Layer Perceptron (MLP): A deep neural network with one hidden layer, trained using cross-entropy as the loss function.

# description
## Dataset

This repository uses the CIFAR-10 dataset.

60,000 color images (32x32 pixels), categorized into 10 classes.
50,000 training images and 10,000 test images.


## read_cifar.py

read_cifar: Loads the CIFAR-10 dataset, returning:

data: A NumPy array of image data.

labels: Corresponding class labels.

read_cifar_preprocess: Similar to read_cifar, but applies channel-wise normalization (zero-center, normalize every color channel).

split_dataset: Splits the dataset into training and testing sets based on a given ratio.

## knn.py

Implementation of the k-Nearest Neighbors (k-NN) algorithm: predicts the class of a data point based on the majority class of its k nearest neighbors in the feature space, using a distance metric like Euclidean distance.

distance_matrix: Computes pairwise distances between training and test sets.

knn_predict: Predicts labels for test data using k-NN.

evaluate_knn: Evaluates the classification accuracy for different values of k.




## mlp.py

Implementation of a Multi-Layer Perceptron (MLP) for image classification: A feedforward neural network one hidden layers that learns to map input to output classes through backpropagation, optimizing with cross-entropy as the loss function.


Key Functions:

train_mlp & test_mlp: Training and testing processes for the MLP.

run_mlp_training: Executes training with user-defined parameters such as learning rate, number of epochs, and hidden layer size. returns the list of accuracies


# Usage

### Prepare the CIFAR-10 Dataset:

Download and extract the CIFAR-10 dataset to the folder data/cifar-10-batches-py/.
This database can be obtained at the address https://www.cs.toronto.edu/~kriz/cifar.html


### Run knn

In the terminal, use "python knn.py"
Modify the parameters inside if __name__ == "__main__": to adjust the split factor or test different values of k.

### Run MLP:

In terminal, use "python mlp.py"
Adjust parameters such as split factor, number of neurons in the hidden layer, learning rate, and number of training epochs within if __name__ == "__main__":.
Uncomment lines to use read_cifar_preprocess or the run_mlp_training_v2 function.

# results

### k-Nearest Neighbors

![image](results/knn.png?raw=true )

Performance is optimal for k=1 or k=2, achieving around 36% accuracy.
Performance gets worse as k increase. For this dataset, we conclude that k=1 or k=2 is optimal, with around 36% accuracy


### Multi-Layer Perceptron
The small network has difficulty classifing the data, with accuracy gradually increasing from ~10% to ~12%.
Results are shown below:

![image](results/mlp.png?raw=true )
Accuracy results for various values of k are plotted to analyze performance.

some optimization, such as learning rate decay, xavier initialisation, per-channel preprocessing and a lower learning rate (0.001) give slightly better results, with more than 13% accuracy

![image](results/mlp_v2.png?raw=true )