import numpy as np

# Importez les  fonctions 
from mlp import initialization, train_mlp, calculate_accuracy

def test_mlp_training():
    # Paramètres du test
    num_samples = 200
    num_features = 10
    num_classes = 3
    num_hidden_units = 5
    learning_rate = 0.1
    num_epochs = 10

    # Générez des données factices pour le test
    X_train = np.random.randn(num_samples, num_features)
    y_train = np.random.randint(0, num_classes, num_samples)
    X_test = np.random.randn(num_samples, num_features)
    y_test = np.random.randint(0, num_classes, num_samples)

    # Initialisez les poids et les biais
    W1, b1, W2, b2 = initialization(num_features, num_hidden_units, num_classes)

    # Entraînez le modèle
    train_accuracies, test_accuracy = train_mlp(W1, b1, W2, b2, X_train, y_train, learning_rate, num_epochs)

    # Vérifiez si l'accuracy est un nombre entre 0 et 1
    assert 0 <= test_accuracy <= 1

    # Vérifiez si la longueur de la liste des accuracies d'entraînement correspond au nombre d'époques
    assert len(train_accuracies) == num_epochs

    # Vérifiez si les accuracies d'entraînement sont des nombres entre 0 et 1
    for accuracy in train_accuracies:
        assert 0 <= accuracy <= 1

    print("Tous les tests ont réussi avec succès.")


