import numpy as np
import knn 

# Test de la fonction distance_matrix :
def test_distance_matrix():
    X = np.array([[1, 2], [3, 4]])
    Y = np.array([[2, 2], [1, 1]])
    dists = knn.distance_matrix(X, Y)
    assert dists.shape == (2, 2)
    assert np.allclose(dists, np.array([[2, 5], [10, 1]]))
    print("Test for distance_matrix passed.")
    

# Test de la fonction knn_predict :
def test_knn_predict():
    dists = np.array([[2, 5], [10, 1]])
    labels_train = np.array([0, 1])
    k = 1
    y_pred = knn.knn_predict(dists, labels_train, k)
    assert y_pred.shape == (2,)
    assert np.array_equal(y_pred, np.array([0, 1]))
    print("Test for knn_predict passed.")

# Test de la fonction evaluate_knn :
def test_evaluate_knn_accuracy():
    data_train = np.array([[1, 2], [3, 4], [5, 6], [1, 1], [2, 2]])
    labels_train = np.array([0, 1, 2, 0, 1])
    data_test = np.array([[2, 2], [1, 1], [3, 3]])
    labels_test = np.array([1, 0, 1])
    k = 2
    accuracy = knn.evaluate_knn(data_train, labels_train, data_test, labels_test, k)
    assert 0 <= accuracy <= 1
    print("Test for evaluate_knn accuracy passed.")
