[[TOC]]

Comme tout tutoriel, ce document a besoin de vos retours pour s'améliorer! N’hésitez pas à m'envoyez un mail décrivant vos difficultés et, éventuellement, les solutions que vous auriez trouvées pour les contourner.

# Présentation de git 

Ce mini tutoriel consiste en une présentation (très simplifiée) de l'usage du système de gestion de version appelé **git** (à prononcer  ``guite``). La présentation se limite aux usages que nous exploiterons durant les BEs de l'UE Informatique (en particulier: rendus de travail automatisés, pour les BE #3 et #5). 

Il constitue néanmoins une introduction à un outil très utilisé dans le domaine du développement logiciel, et que vous pourriez utiliser à de nombreuses reprises dans votre scolarité (notamment dans les projets de développement en groupe tels que les PE, le PAi ou PAr), et au delà! En tout état de cause, il se justifie pleinement dans le cadre de la crise sanitaire que nous traversons, en proposant un outil collaboratif de travail très performant.

> [wikipédia git](https://fr.wikipedia.org/wiki/Git "link to wikipedia git"): 'Il s'agit du logiciel de gestion de versions le plus populaire qui est utilisé par plus de douze millions de personnes.' (en 2016) 

## Présentation succincte de git et gitlab
**git** est un système de contrôle de version (*version control system*, ou VCS)

- Un ensemble d'outils logiciels pour:    
    - Mémoriser et retrouver différentes versions d'un projet.    
    - Faciliter le travail collaboratif.    
- Initialement développé par Linus Torvalds pour faciliter le développement du noyau Linux:    
    - Logiciel libre / open source.    
    - Disponible sur toutes les plates-formes.   

*Remarque :* **git** est disponible par défaut sur les machines *Mac OS X* et *Linux*. S'il est absent de *Windows* (pour le savoir, lancez la commande *git* dans un Terminal), alors installez-le à partir de ce lien : [git-scm](https://git-scm.com/download/win).

Il existe de très nombreux tutoriels sur **git** (vidéo ou slides), complets mais qui peuvent rapidement paraître ardus pour les débutants (*p. ex.* [slides de Robin Passama](https://romainlebreton.github.io/ProgWeb-CoteServeur/assets/initiation%20GIT_IUT.pdf)). La maîtrise de **git** n'est en aucun cas indispensable pour les BEs. Par contre, maîtriser la suite de ce tuto l'est pour le rendu de vos travaux évalués (BE #3 et #5)!

**gitlab** est une application web basée sur **git**.

- Permet de gérer:    
    - Le cycle de vie de projets git.    
    - Les participants aux projets (rôles, groupes...). 
    - La communication entre ces participants.    
- Développée par une société privée, mais qui offre des services gratuits (dans notre cas, la version *GitLab Community Edition*).

Dans le cadre des BEs, nous utiliserons le **gitlab** installé par la DSI sur les serveurs de l'École, accessible à cette [adresse](https://gitlab.ec-lyon.fr/users/sign_in). Il vous suffit de vous logger avec vos identifiants habituels de l'École pour accéder à votre espace **gitlab**. Pour l'instant votre espace de projets est sans doute vide, mais nous allons le peupler. Avant de poursuivre, veuillez copier en mémoire l'url de votre espace, c'est-à-dire le lien qui ressemblera à ça: *https://gitlab.ec-lyon.fr/xyyyyy* (mais avec votre propre loggin bien sûr).

La démarche que nous allons maintenant décrire est résumée par ce diagramme:

 1. La première étape consiste à créer une copie (appelé ``fork`` dans le vocabulaire **gitlab**) de l'énoncé de BE sur votre espace **gitlab**.
 2. La seconde consiste à créer une copie du fork sur votre disque dur. C'est à cet endroit que vous rédigerez vos programmes pour répondre aux questions de l'énoncé. 
 3. La troisième étape consistera à mettre à jour le ``fork``. L'encadrant de TD viendra alors récupérer vos travaux sur votre espace **gitlab** pour évaluer votre travail personnel. 

<center><img src="figures/Fork.png" style="width:50%"/></center>


## 1. Fork (copie de projet) des énoncés de BE de INF-TC2

Pour la démonstration, nous allons créer, sur votre espace **gitlab**, une copie du projet contenant l'énoncé du BE #3 de INF-TC2 ; cette opération s'appelle un ``fork`` et pourra être appliquée sur d'autres projets (en particulier le BE #5, et les BEs de INF-TC1, en fonction des consignes de vos encadrants). Suivez le guide...

- Ouvrez la page https://gitlab.ec-lyon.fr/sderrode/INF-TC2-BE3. Vous observez le projet qui héberge l'énoncé du BE #3 sur le **gitlab** de l'École.    
- Cliquez sur le bouton ``Fork``(en haut à droite de l'interface). Sélectionnez ensuite votre espace **gitlab** pour lancer la copie.

En revenant sur votre espace **gitlab**, vous pouvez constater la présence de votre copie personnelle du projet. L'interface WEB **gitlab** ne permet pas de modifier facilement les fichiers et encore moins de programmer. Nous passons donc à l'étape suivante qui consiste à importer une copie locale du projet sur votre ordinateur.

 <center><img src="figures/ForkSuccess.png" style="width:50%"/></center>

### Important!
**Important** Il vous faut paramétrer votre projet pour le rendre privé, mais permettre à votre encadrant de venir consulter votre travail. Pour cela, veuillez suivre scrupuleusement les étapes suivantes :

 1. Rendez-vous sur votre espace **gitlab** et sélectionnez votre projet.    
 1. Dans la barre de menu latérale à gauche de l'interface Web, sélectionnez l'icône représentant une roue crantée correspondant à ``Settings``. Dans le sous-menu ``Général``, appuyez sur le bouton ``Expand`` correspondant à la ligne : *Visibility, project features, permissions*. Dans *Project visibility*, sélectionnez ``Private`` (au lieu de ``Public``). N'oubliez pas de sauver les changements à l'aide du bouton qui se situe un peu plus bas.    
 <center><img src="figures/Visibility.png" style="width:50%"/></center>   
 1. Toujours dans la barre de menu latérale à gauche de l'interface Web, sélectionnez maintenant le menu ``Members`` (juste au dessus de ``Settings``). Sélectionnez dans la liste déroulante de l'espace *Gitlab Members or Email address* votre encadrant, et donnez-lui le rôle de ``reporter`` (au lieu de ``Guest``). N'oubliez pas finalement d'inviter votre encadrant en cliquant sur le bouton ``Invite``.    
 <center><img src="figures/AjoutEncadrant.png" style="width:50%"/></center>


 Voilà, votre ``fork`` est paramétré

## 2. Importation du projet sur votre machine

- Téléchargez, installez et lancez l'application [Github Desktop](https://desktop.github.com/).    
- Depuis la page de votre espace **gitlab**, cliquez sur l'icône ``Clone`` et copiez le lien ``Clone with HTTPS`` (qui ressemble à https://gitlab.ec-lyon.fr/xyyyyy/INF-TC2-BE3.git).    
- Dans l'application ``Github Desktop``, sélectionnez l'option ``Clone a Repository from the Internet``, puis l'onglet ``URL`` (ou menu ``File``, ``Clone repository``). Copiez l'adresse précédemment mise en mémoire dans l'espace dédié, et choisissez dans ``local path`` le répertoire de votre machine dans lequel votre projet sera copié. Appuyez sur le bouton ``Clone`` de l'interface pour lancer l'importation de votre projet **gitlab** sur votre machine.    

<center><img src="figures/ImportGithubDesktop.png" style="width:50%"/></center>

- Observez alors la fenêtre qui apparaît. Elle vous permet     
    - soit d'ouvrir les fichiers avec votre éditeur préféré (vous pouvez le configurer en suivant le lien ``Preferences``, puis menu ``Integrations``). Comme nous programmons avec ``Anaconda/Spyder``, cette possibilité ne sera pas utile.    
    - soit d'ouvrir un gestionnaire de fichiers vous permettant de visualiser votre copie locale du projet. En navigant dans les sous-répertoires, vous verrez apparaître l'énoncé du BE (au format ``markdown``). 

Les étapes décrites jusqu'ici ne doivent être faites qu'une seule fois par projet.

----

Vous pouvez maintenant modifier les fichiers de votre copie locale, ou en créer d'autres. Pour cela, vous pouvez utiliser ``Spyder``, ou tout autre éditeur de texte, à votre convenance! Pensez bien à sauvegarder vos scripts ``python`` dans le dossier du BE!

À ce stade, seule votre copie locale est à jour, il faut ensuite penser à publier vos modifications sur votre espace **gitlab**. A minima, vous devrez le faire à chaque fin de séance de BE. 

## 3. Mise à jour de votre espace gitlab

La mise à jour de votre espace **gitlab** (au plus tard le dernier jour autorisé pour rendre votre travail) se fait en 2 étapes:

 1. Ouvrez à nouveau le logiciel ``GitHub Desktop``. L'application montre alors les différences, fichier par fichier,  qui existent entre la précédente version de vos fichiers et les changements que vous avez effectués depuis. Pour que **git** enregistre ces changements, veuillez taper un petit texte qui donne une explication sur vos modifications (typiquement: *réponse aux questions du BE 3*) dans la barre en bas à gauche, et appuyez sur le bouton ``Commit to master``.    
<center><img src="figures/Commit.png" style="width:50%"/></center>   
 1. Pour mettre à jour ces changements sur votre espace **gitlab**, appuyez sur le bouton ``Push Origin``. Veuillez ensuite constater que les changements ont bien été publiés en consultant l'url de votre projet **gitlab** (faites un rafraîchissement de la page si nécessaire).

En général, on réalise l'étape 1. très régulièrement (même si votre programme ne fonctionne pas). L'étape 2. est réalisée lorsque l'on a terminé  un algorithme par exemple ; on prend soin de publier des programmes qui fonctionnent, sans nécessairement qu'ils soient parfaits. Vous devrez réaliser *au minimum* les étapes 1. et 2. avant la date butoir pour le rendu de votre travail.

Et voilà, le tour est joué ! 

<!--
Vous connaissez maintenant les étapes pour publier vos modifications. 

La dernière étape décrite dans ce tuto concerne la mise à jour de votre ``fork`` lorsque les énoncés de BE changent ou lorsque de nouveaux énoncés sont publiés sur le projet original : https://gitlab.ec-lyon.fr/sderrode/INF-TC2.


## 3. Mise à jour de votre espace **gitlab**

Les énoncés des BE sont déposés sur l'espace https://gitlab.ec-lyon.fr/sderrode/INF-TC2 au fur et à mesure des semaines de BE. Et votre copie doit être mise à jour pour tenir compte de ces modifications.

Pour que cela se fasse automatiquement, veuillez suivre les étapes suivante (à ne réaliser qu'une seule fois):
 - Vous devez modifier les paramètres de votre fork. On accède aux paramètres en cliquant sur l'icône représentant la roue crantée (``Settings``), cherchez bien sur la page Web ! Allez ensuite dans le sous-menu ``Repository`` et sélectionnez le bouton ``Expand`` en face de ``Miroring repositories``. 
  - Dans le champs correspondant à ``Git repository URL``, copiez le lien https://gitlab.ec-lyon.fr/sderrode/INF-TC2, ajoutez un mot de passe, et appuyer sur le bouton ``Miror repository``.

Voilà le tour est joué ! Ainsi, dès qu'un changement apparaîtra sur le site d'origine, votre copie sur **gitlab** en tiendra compte. Mais pas votre copie locale sur votre machine! Avant de travaillez vos programmes (typiquement: en début de séance de BE), il faut donc penser à mettre à jour votre copie locale des fichiers. Pour cela, lancez  ``GitHub Desktop``. Si des changements nécessitent d'être importés, alors l'interface vous proposera de le faire. Bien sûr, cette étape fusionne les fichiers sans rien vous faire perdre de votre travail personnel.

-->

