import streamlit as st
from datetime import date, datetime, timedelta
import sqlite3
import pandas as pd
import numpy as np  # Add this line to import numpy
st.title("Page de gestion des employés")
st.write("Bienvenue!😃")
# Connect to the access control database
conn = sqlite3.connect('donnees/access_control.db')
cursor = conn.cursor()
if 'logged_in' not in st.session_state:
    st.session_state.logged_in = False

if not st.session_state.logged_in:
    # Create a login form
    st.header("Login")
    employee_code = st.text_input("Code Employé")
    mot_de_passe = st.text_input("Mot de passe", type="password")
    login_button = st.button("Login")

    if login_button:
        cursor.execute("SELECT status FROM employees WHERE employee_code = ? AND mot_de_passe = ?", (employee_code, mot_de_passe))
        result = cursor.fetchone()
        if result and (result[0] == 'RH' or result[0] == 'admin'):
            st.session_state.logged_in = True
            st.session_state.status = result[0]
        else:
            st.error("Accès refusé. Veuillez vérifier vos informations de connexion.")

    conn.close()

# Check if the user is logged in and has the correct status
if 'logged_in' in st.session_state and st.session_state.logged_in:
    
    if 'page' not in st.session_state:
        st.session_state.page = None
    tab1, tab2, tab3,tab4, tab5 = st.tabs(["💳Suivi des salaires","🕒Employés +3 ans d'anciénneté", "🚀Productivité","🎁Primes","🆕Création d'un compte employé"])
    with tab1:
        st.header("Suivi Employés")
        popover = st.popover("Filtre employés à afficher")
        total = popover.checkbox("Salaires des employés par semaine", True)
        dimin = popover.checkbox("Salaires des employés ayant eu une diminution par semaine", True)
        conn= sqlite3.connect(r'donnees/company.db') 
        cursor = conn.cursor()
        cursor.execute("SELECT DATE_LUNDI,SALAIRE_SEMAINE.NUMERO_EMPLOYE,NOM,PRENOM,SALAIRE_BASE,SALAIRE_AVANT, SALAIRE_APRES,NB_HEURES, NB_PRODUCTION,RETARD,ANCIENNETE,NOEL,  DATE_DEBUT FROM SALAIRE_SEMAINE JOIN EMPLOYE ON EMPLOYE.NUMERO_EMPLOYE = SALAIRE_SEMAINE.NUMERO_EMPLOYE")
        employees = cursor.fetchall()
        # Convert the employee records to a DataFrame
        df = pd.DataFrame(employees, columns=[desc[0] for desc in cursor.description])
        df.columns = ['Date du lundi', 'Numéro employé', 'Nom', 'Prénom', 'Salaire base', 'Salaire avant primes','Salaire réel', 'Nombre d\'heures', 'Nombre de production', 'Retard','Ancienneté', 'Bonus de Noël', 'Date de début']
        if total:
            # Add code for "Suivi Employés" page here
            st.write("Salaires des employés par semaine (question 1)")
            st.dataframe(df)
        if dimin:
            st.write("Salaires des employés ayant eu une diminution par semaine (question 3)")
            st.dataframe(df[df['Salaire avant primes']<df['Salaire base']])

        conn.close()
    with tab2:
        conn= sqlite3.connect(r'donnees/company.db') 
        cursor = conn.cursor()
        on = st.toggle("Employés avec 3 ans d'anciénneté")
        cursor.execute("SELECT NUMERO_EMPLOYE,NOM,PRENOM,TYPE,DATE_DEBUT FROM EMPLOYE")
        employees = cursor.fetchall()
        df=pd.DataFrame(employees, columns=[desc[0] for desc in cursor.description])
        from datetime import datetime
        today = datetime.today()
        df['DATE_DEBUT'] = pd.to_datetime(df['DATE_DEBUT'])
        if on:
            st.header("Liste des employés avec 3 ans d'anciénneté")
            df = df[(today - df['DATE_DEBUT']).dt.days > 3 * 365]
            df.columns = ['Numéro employé', 'Nom', 'Prénom', 'Type du contrat', 'Date de début']
            st.write("Liste des employés journaliers (question 2)")
            st.dataframe(df[df['Type du contrat']==1])
            st.write("Liste des employés par production")
            st.dataframe(df[df['Type du contrat'] == 2])
        else:
            
            df.columns = ['Numéro employé', 'Nom', 'Prénom', 'Type du contrat', 'Date de début']
            st.header("Liste de la totalité des employés")
            st.write("Liste des employés journaliers")
            st.dataframe(df[df['Type du contrat']==1])
            st.write("Liste des employés par production")
            st.dataframe(df[df['Type du contrat'] == 2])

    with tab3:
        conn= sqlite3.connect(r'donnees/company.db')
        cursor = conn.cursor()
        cursor.execute("SELECT NUMERO_EMPLOYE,NOM,PRENOM,TYPE FROM EMPLOYE")
        employees = cursor.fetchall()
        liste_employes=sorted([ (str(employees[i][0]) + " - " + employees[i][1] + " " + employees[i][2]) for i in range(len(employees))])
        employe = st.selectbox("Employé", options=liste_employes, index=None,placeholder="Choisir un employé")
        if employe is None:
            st.write("")
        else:
            df_employees = pd.DataFrame(employees, columns=[desc[0] for desc in cursor.description])
            if int(df_employees[df_employees['NUMERO_EMPLOYE']==int(employe.split(" - ")[0])]['TYPE']) == 1:
                cursor.execute("SELECT DATE_LUNDI, NB_HEURES FROM SALAIRE_SEMAINE WHERE NUMERO_EMPLOYE = ?", (int(employe.split(" - ")[0]),))
                df=pd.DataFrame(cursor.fetchall(), columns=[desc[0] for desc in cursor.description])
                st.write("Nombre d'heures travaillées par semaine pour l'employé sélectionné")
                st.dataframe(df)
                import matplotlib.pyplot as plt

                # Filter the last 10 weeks
                df['DATE_LUNDI'] = pd.to_datetime(df['DATE_LUNDI'])
                last_10_weeks = df.sort_values(by='DATE_LUNDI').tail(10)

                # Calculate the average hours per week
                average_hours = last_10_weeks['NB_HEURES'].mean()

                # Plot the data
                fig, ax = plt.subplots()
                ax.plot(last_10_weeks['DATE_LUNDI'], last_10_weeks['NB_HEURES'], marker='.', linestyle='-',linewidth=0.1, label='Nombre d\'heures travaillées', color='blue')
                ax.axhline(y=average_hours, color='red', linestyle='--',linewidth=0.5, label=f'Moyenne ({average_hours:.2f})')
                ax.set_xlabel('Date', fontsize=4)
                ax.set_ylabel('Nombre d\'heures', fontsize=4)
                ax.set_title('Nombre d\'heures travaillées par semaine (dernières 10 semaines)', fontsize=4)
                ax.tick_params(axis='both', which='major', labelsize=3, rotation=45)
                fig.set_size_inches(3, 2)
                ax.legend(fontsize=4)

                # Display the plot in Streamlit
                st.pyplot(fig)
            else:
                cursor.execute("SELECT DATE_LUNDI, NB_PRODUCTION FROM SALAIRE_SEMAINE WHERE NUMERO_EMPLOYE = ?", (int(employe.split(" - ")[0]),))
                df=pd.DataFrame(cursor.fetchall(), columns=[desc[0] for desc in cursor.description])
                st.write("Nombre de production par semaine pour l'employé sélectionné (question 4)")
                st.dataframe(df)
                import matplotlib.pyplot as plt

                # Filter the last 10 weeks
                df['DATE_LUNDI'] = pd.to_datetime(df['DATE_LUNDI'])
                last_10_weeks = df.sort_values(by='DATE_LUNDI').tail(10)

                # Calculate the average production per week
                average_production = last_10_weeks['NB_PRODUCTION'].mean()

                # Plot the data
                fig, ax = plt.subplots()
                ax.plot(last_10_weeks['DATE_LUNDI'], last_10_weeks['NB_PRODUCTION'], marker='.', linestyle='-', linewidth=0.1, label='Nombre de pièces produites', color='blue')
                ax.axhline(y=average_production, color='red', linestyle='--', linewidth=0.5, label=f'Moyenne ({average_production:.2f})')
                ax.set_xlabel('Date', fontsize=4)
                ax.set_ylabel('Nombre de pièces produites', fontsize=4)
                ax.set_title('Nombre de pièces produites par semaine (dernières 10 semaines)', fontsize=4)
                ax.tick_params(axis='both', which='major', labelsize=3, rotation=45)
                fig.set_size_inches(3, 2)
                ax.legend(fontsize=4)

                # Display the plot in Streamlit
                st.pyplot(fig)

    with tab4:
        # Fonction pour générer les lundis
        def generate_mondays(start_date):
            """
            Génère une liste de lundis à partir d'une date donnée jusqu'à un an après.
            
            :param start_date: Date de début au format 'YYYY-MM-DD'
            :return: Liste de lundis au format 'YYYY-MM-DD'
            """
            start = datetime.strptime(start_date, '%Y-%m-%d')
            end_date = start + timedelta(days=365)
            
            # Ajuster au premier lundi
            if start.weekday() != 0:
                start += timedelta(days=(7 - start.weekday()))
            
            mondays = []
            current_date = start
            while current_date <= end_date:
                mondays.append(current_date.strftime('%Y-%m-%d'))
                current_date += timedelta(weeks=1)
            
            return mondays
        
        # Connexion à la base de données
        conn = sqlite3.connect('donnees/company.db')
        cursor = conn.cursor()
        # Génération des lundis
        mondays = generate_mondays(datetime.now().strftime('%Y-%m-%d'))
        
        # Exemple d'opérations avec les employés
        chrismas_day = datetime(2025, 12, 25)
        cursor.execute("SELECT NUMERO_EMPLOYE, NOM, PRENOM, CS_PRODUCTION, CS_JOURNEE, DATE_DEBUT FROM EMPLOYE")
        employees = cursor.fetchall()
        
        prime_totale = []
        prime_partielle = []
        Bonus=[]
        for employee in employees:
            NUMERO_EMPLOYE, NOM, PRENOM, CS_PRODUCTION, CS_JOURNEE, DATE_DEBUT = employee
            start_date = datetime.strptime(DATE_DEBUT, '%Y-%m-%d')
            
                
            for LUNDI in mondays:
                lundi = datetime.strptime(LUNDI, '%Y-%m-%d')
                delta = lundi - start_date
                delta_days = delta.days
                delta_noel =lundi - chrismas_day
                delta_noel_days=delta_noel.days
                prime_partielle=0
                prime_totale=0
                prime_anniversaire=0

                if 0 <= delta_noel_days%365<= 6:  
                    if delta.days >= 365:
                        if CS_JOURNEE is not None:
                            cursor.execute(f"SELECT SALAIRE_SEMAINE_BASE FROM GRILLE_SALAIRE_HORAIRE WHERE CS_HORAIRE = {CS_JOURNEE}")
                            salaire_base=cursor.fetchone()[0]
                            prime_totale= salaire_base*4.5
                        if CS_PRODUCTION is not None:
                            cursor.execute(f"SELECT SALAIRE_SEMAINE_BASE FROM GRILLE_SALAIRE_PROD WHERE CS_PRODUCTION = {CS_PRODUCTION}")
                            salaire_base=cursor.fetchone()[0]
                            prime_totale= salaire_base*4.5
                    else:
                        if CS_JOURNEE is not None:
                            cursor.execute(f"SELECT SALAIRE_SEMAINE_BASE FROM GRILLE_SALAIRE_HORAIRE WHERE CS_HORAIRE = {CS_JOURNEE}")
                            salaire_base=cursor.fetchone()[0]
                            prime_partielle= max(0, salaire_base  * delta.days / 365 )*4.5
                        if CS_PRODUCTION is not None:
                            cursor.execute(f"SELECT SALAIRE_SEMAINE_BASE FROM GRILLE_SALAIRE_PROD WHERE CS_PRODUCTION = {CS_PRODUCTION}")
                            salaire_base=cursor.fetchone()[0]
                            prime_partielle=max(0, salaire_base* delta.days / 365 )*4.5
                
                if 0 <= abs(delta_days%365)<= 6:  
                        if CS_JOURNEE is not None:
                            cursor.execute(f"SELECT SALAIRE_SEMAINE_BASE FROM GRILLE_SALAIRE_HORAIRE WHERE CS_HORAIRE = {CS_JOURNEE}")
                            salaire_base=cursor.fetchone()[0]
                            prime_anniversaire= salaire_base
                        if CS_PRODUCTION is not None:
                            cursor.execute(f"SELECT SALAIRE_SEMAINE_BASE FROM GRILLE_SALAIRE_PROD WHERE CS_PRODUCTION = {CS_PRODUCTION}")
                            salaire_base=cursor.fetchone()[0]
                            prime_anniversaire= salaire_base
                Bonus.append((NUMERO_EMPLOYE, NOM, PRENOM, DATE_DEBUT, LUNDI, prime_totale,prime_partielle, prime_anniversaire, prime_partielle+prime_totale+prime_anniversaire ))
        Bonus = pd.DataFrame(Bonus, columns=['NUMERO_EMPLOYE','NOM', 'PRENOM' ,'DATE_DEBUT','LUNDI','PRIME_NOEL','PRIME_NOEL_PARTIELLES','PRIME_ANNIVERSAIRE','PRIMES'])
        Bonus = Bonus[['LUNDI', 'NUMERO_EMPLOYE', 'NOM', 'PRENOM', 'DATE_DEBUT', 'PRIME_NOEL', 'PRIME_NOEL_PARTIELLES', 'PRIME_ANNIVERSAIRE', 'PRIMES']]
        Bonus.columns = ['Lundi', 'Numéro employé', 'Nom', 'Prénom', 'Date de début', 'Prime Noël', 'Prime Noël partielles', 'Prime anniversaire', 'Primes']
        Bonus[Bonus['Primes']>0].head(50)
        st.header("Primes de Noël et d'anniversaire pour les employés pour l'an à venir")
        options = [ "Primes d'anniversaire","Primes de Noël complètes","Primes de Noël partielles" ]
        selections = {option: st.checkbox(option) for option in options}
        if selections["Primes de Noël partielles"]:
            st.write("Primes de Noël partielles (question 6)")
            st.dataframe(Bonus[Bonus['Prime Noël partielles']>0][["Lundi", "Numéro employé", "Nom", "Prénom", "Date de début", "Prime Noël partielles"]])
        if selections["Primes de Noël complètes"]:
            st.write("Primes de Noël complètes (question 5/7)")
            st.dataframe(Bonus[Bonus['Prime Noël']>0][["Lundi", "Numéro employé", "Nom", "Prénom", "Date de début", "Prime Noël"]])
        if selections["Primes d'anniversaire"]:
            st.write("Primes d'anniversaire (question 5)")
            st.dataframe(Bonus[Bonus['Prime anniversaire']>0][["Lundi", "Numéro employé", "Nom", "Prénom", "Date de début", "Prime anniversaire"]])

        

    with tab5:
        st.header("Création de compte employé")
        conn= sqlite3.connect(r'donnees/company.db')
        cursor = conn.cursor()
        cursor.execute("SELECT MAX(NUMERO_EMPLOYE) FROM EMPLOYE")
        max_numero_employe = cursor.fetchone()[0]

        # Set the employee number to the next available number
        NUMERO_EMPLOYE = max_numero_employe + 1 if max_numero_employe is not None else 1

        # Employee type

        # Employee name
        NOM = st.text_input("Nom", value='')

        # Employee first name
        PRENOM = st.text_input("Prénom", value='')
        TYPE = st.selectbox("Type de contrat", options=[1, 2], format_func=lambda x: "Journalier" if x == 1 else "Production", index=0)

        # Conditional fields based on employee type
        if TYPE == 2:
            CS_PRODUCTION = st.number_input("Code salarial de production", min_value=1,max_value=6, step=1, value=None)
            CS_JOURNEE = None
        else:
            CS_JOURNEE = st.number_input("Code salarial journalier", min_value=1,max_value=9, step=1, value=1)
            CS_PRODUCTION = None

        # Start date
        date_debut = st.date_input("date de début", value=date(2024, 11, 13))

        # Submit button
        if st.button("Create Account"):
            # Connect to the database
            conn=sqlite3.connect(r'donnees/company.db')
            cursor = conn.cursor()
            cursor.execute("""
                SELECT NUMERO_EMPLOYE FROM EMPLOYE
                WHERE NOM = ? AND PRENOM = ? AND DATE_DEBUT = ?     
            """, (NOM, PRENOM, date_debut))
            existing_employee = cursor.fetchone()

            if existing_employee:
                st.write(f"Cet employé est déjà enregistré avec le numéro employé: {existing_employee[0]}")
                conn.close()

            else:
                cursor.execute("""
                    INSERT INTO EMPLOYE (NUMERO_EMPLOYE, TYPE, NOM, PRENOM, CS_PRODUCTION, CS_JOURNEE, DATE_DEBUT)
                    VALUES (?, ?, ?, ?, ?, ?, ?)
                """, (NUMERO_EMPLOYE, TYPE, NOM, PRENOM, CS_PRODUCTION if CS_PRODUCTION is not None else None, CS_JOURNEE if CS_JOURNEE is not None else None, date_debut))
                # Commit the transaction
                conn.commit()

                st.write("Nouvel employé enregistré!")
                st.write(f"Numéro employé: {NUMERO_EMPLOYE}")
                st.write(f"Type de contrat: {'Journalier' if TYPE == 1 else 'Production'}")
                st.write(f"Nom: {NOM}")
                st.write(f"Prénom: {PRENOM}")
                if TYPE == 2:
                    st.write(f"Code salarial de production: {CS_PRODUCTION}")
                else:
                    st.write(f"code salarial journalier: {CS_JOURNEE}")
                st.write(f"Date du début du contrat: {date_debut}")
                conn.close()
    st.stop()