const { generateDepartmentAveragesAndColors } = require('./indicateurs.js');
const { generateMoyenne, generateMoyenneByYear, generateTop5Communes, generateFlop5Communes, generateCommuneAveragesByScoreType } = require('./metrics.js');

const express = require("express");
const cors = require("cors");

const app = express();
app.use(cors());

const PORT = 5003;


app.get("/api/indicateurs", async (req, res) => {
    const { type = "indicateurs", year = "2024" } = req.query;

    if (!type || !year) {
        return res.status(400).send('Veuillez spécifier les paramètres "type" et "year".');
    }

    try {
        const { averages, colors, top5dept, flop5dept } = await generateDepartmentAveragesAndColors(type, year);
        res.json({ averages, colors, top5dept, flop5dept });
    } catch (error) {
        console.error('Erreur lors du traitement des indicateurs :', error);
        res.status(500).send(error.message || 'Erreur serveur.');
    }
});

app.get("/api/moyenne", async (req, res) => {
    const { type = "indicateurs", year = "2024" } = req.query;
    try {
        const moyenne = await generateMoyenne(type, year);
        res.json({ moyenne });
    } catch (error) {
        console.error('Erreur lors du calcul de la moyenne :', error);
        res.status(500).send('Erreur lors du traitement du fichier CSV');
    }
});

app.get("/api/moyenneByYear", async (req, res) => {
    const { type = "indicateurs" } = req.query;
    try {
        const moyennes = await generateMoyenneByYear(type);
        res.json({ moyennes });
    } catch (error) {
        console.error('Erreur lors du calcul des moyennes par année :', error);
        res.status(500).send('Erreur lors du traitement des fichiers CSV');
    }
});

app.get("/api/communetopandflop5", async (req, res) => {
    const { dept = "1", year = "2024", type = "indicateurs" } = req.query;
    try {
        const top5 = await generateTop5Communes(dept, year, type);
        const flop5 = await generateFlop5Communes(dept, year, type);
        res.json({ top5, flop5 });
    } catch (error) {
        console.error('Erreur lors du calcul des top et flop 5 communes :', error);
        res.status(500).send('Erreur lors du traitement des fichiers CSV');
    }
});

app.get("/api/communeaverage", async (req, res) => {
    const { dept = "1", year = "2024", type = "indicateurs" } = req.query;
    try {
        console.log(dept)
        const averages = await generateCommuneAveragesByScoreType(dept, year, type);
        res.json({ averages });
    } catch (error) {
        console.error('Erreur lors du calcul des moyennes par commune :', error);
        res.status(500).send('Erreur lors du traitement des fichiers CSV');
    }
});

// exemple d'url pour la commune average
// http://localhost:5003/api/communeaverage?dept=1&year=2024&type=indicateurs

app.listen(PORT, () => {
    console.log(`Serveur lancé sur http://localhost:${PORT}`);
});
