import matplotlib.pyplot as plt
import numpy as np

def read_data(file_name, delimiter=','):
    """ Read the data file and returns the corresponding matrices

    Parameters
    ----------
    file_name : file name containg data
    delimiter : character separating columns in the file ("," by default)

    Returns
    -------
    X : data matrix of size [N, nb_var]
    Y : matrix containg values of the target variable of size [N, 1]
    
    with N : number of elements and nb_var : number of predictor variables

    """
    
    data = np.loadtxt(file_name, delimiter=delimiter)
    
    #######################
    ##### To complete ##### 
    #######################
    
    return X, Y, N, nb_var

def normalization(X):
    """ Normalize the provided matrix (substracts mean and divides by standard deviation)
    

    Parameters
    ----------
    X : data matrix of size [N, nb_var]
    
    with N : number of elements and nb_var : number of predictor variables

    Returns
    -------
    X_norm : normalized data matrix of size [N, nb_var]
    mu : means of the variables of sizede dimension [1,nb_var]
    sigma : standar deviations of the variables of size [1,nb_var]

    """
    
    #######################
    ##### To complete ##### 
    #######################

    return X_norm, mu, sigma

def sigmoid(z):
    """ Compute the value of the sigmoid function applied to z
    
    Parameters
    ----------
    z : can be a scalar value or a matrix

    Returns
    -------
    s : sigmoid value of z. Same size as z

    """

    #######################
    ##### To complete ##### 
    #######################

    return s

def compute_loss(X, Y, theta):
    """ Compute the loss function value (log likelihood)
    
    Parameters
    ----------
    X : data matrix of size [N, nb_var+1]
    Y : matrix containg values of the target variable of size [N, 1]
    theta : matrix containing the theta parameters of the linear model of size [1, nb_var+1]
    
    with N : number of elements and nb_var : number of predictor variables

    Returns
    -------
    loss : loss function value (log likelihood)

    """

    #######################
    ##### To complete ##### 
    #######################

    return loss

def gradient_descent(X, Y, theta, alpha, nb_iters):
    """ Training to compute the logistic regression parameters by gradient descent
    
    Parameters
    ----------
    X : data matrix of size [N, nb_var+1]
    Y : matrix containg values of the target variable of size [N, 1]
    theta : matrix containing the theta parameters of the logistic model of size [1, nb_var+1]
    alpha : learning rate
    nb_iters : number of iterations
    
    with N : number of elements and nb_var : number of predictor variables


    Returns
    -------
    theta : matrix containing the theta parameters learnt by gradient descent of size [1, nb_var+1]
    J_history : list containg the loss function values for each iteration of length nb_iters


    """
    
    # Init of useful variables
    N = X.shape[0]
    J_history = np.zeros(nb_iters)

    for i in range(0, nb_iters):

        #######################
        ##### To complete ##### 
        #######################
        

    return theta, J_history

def prediction(X,theta):
    """ Predict the class of each element in X
    
    Parameters
    ----------
    X : data matrix of size [N, nb_var+1]
    Y : matrix containg values of the target variable of size [N, 1]
    theta : matrix containing the theta parameters of the logistic model of size [1, nb_var+1]
    
    with N : number of elements and nb_var : number of predictor variables


    Returns
    -------
    p : matrix of size [N,1] providing the class of each element in X (either 0 or 1)

    """

    #######################
    ##### To complete ##### 
    #######################

    return p

def classification_rate(Ypred,Y):
    """ Compute the classification rate (proportion of correctly classified elements)
    
    Parameters
    ----------
    Ypred : matrix containing the predicted values of the class of size [N, 1]
    Y : matrix containing the values of the target variable of size [N, 1]
    
    with N : number of elements 


    Returns
    -------
    r : classification rate

    """

    #######################
    ##### To complete ##### 
    #######################

    return r

def display(X, Y):
    """ Display of data in 2 dimensions (2 dimensions of X) and class representation (provided by Y) by a color
    
    Parameters
    ----------
    X : data matrix of size [N, nb_var+1]
    Y : matrix containg values of the target variable of size [N, 1]
    
    with N : number of elements and nb_var : number of predictor variables

    Returns
    -------
    None

    """

    #######################
    ##### To complete ##### 
    #######################


if __name__ == "__main__":
    # ===================== Part 1: Data loading and normalization =====================
    print("Data loading ...")

    X, Y, N, nb_var = read_data("notes.txt")

    # Print of the ten first examples of the dataset
    print("Print of the ten first examples of the dataset : ")
    for i in range(0, 10):
        print(f"x = {X[i,:]}, y = {Y[i]}")
        
    # Normalization of variables 
    print("Normalization of variables  ...")

    X, mu, sigma = normalization(X)

    # Add one column of 1 values to X (for theta 0)
    X = np.hstack((np.ones((N,1)), X)) 

    # Display in 2D of data points and actual class representation by a color
    if nb_var == 2 :
        plt.figure(0)
        plt.title("Coordinates of data points in 2D - Reality")
        display(X,Y)

    # ===================== Part 2: Gradient descent =====================
    print("Training by gradient descent ...")

    # Choice of the learning rate and number of iterations
    alpha = 0.01
    nb_iters = 10000

    # Initialization of theta and call to the gradient descent function
    theta = np.zeros((1,nb_var+1))
    theta, J_history = gradient_descent(X, Y, theta, alpha, nb_iters)

    # Display of the loss function values obtained during gradient descent training
    plt.figure()
    plt.title("Loss function values obtained during gradient descent training")
    plt.plot(np.arange(J_history.size), J_history)
    plt.xlabel("Nomber of iterations")
    plt.ylabel("Loss function J")

    # Print of theta values
    print(f"Theta computed by gradient descent : {theta}")

    # Evaluation of the model
    Ypred = prediction(X,theta)

    print("Classification rate : ", classification_rate(Ypred,Y))

    # Display in 2D of data points and predicted class representation by a color
    if nb_var == 2 :
        plt.figure(0)
        plt.title("Coordinates of data points in 2D - Prediction")
        display(X,Y)
        
    plt.show()

    print("Logistic Regression completed.")
