import matplotlib.pyplot as plt
import numpy as np

def read_data(file_name, delimiter=','):
    """ Read the data file and returns the corresponding matrices

    Parameters
    ----------
    file_name : file name containg data
    delimiter : character separating columns in the file ("," by default)

    Returns
    -------
    X : data matrix of size [N, nb_var]
    Y : matrix containg values of the target variable of size [N, 1]
    
    with N : number of elements and nb_var : number of predictor variables

    """
    
    data = np.loadtxt(file_name, delimiter=delimiter)
    
    #######################
    ##### To complete ##### 
    #######################
    
    return X, Y, N, nb_var

def normalization(X):
    """ Normalize the provided matrix (substracts mean and divides by standard deviation)
    

    Parameters
    ----------
    X : data matrix of size [N, nb_var]
    
    with N : number of elements and nb_var : number of predictor variables

    Returns
    -------
    X_norm : normalized data matrix of size [N, nb_var]
    mu : means of the variables of sizede dimension [1,nb_var]
    sigma : standar deviations of the variables of size [1,nb_var]

    """
    
    #######################
    ##### To complete ##### 
    #######################

    return X_norm, mu, sigma

def compute_loss(X, Y, theta):
    """ Compute the loss function value (mean square error)
    
    Parameters
    ----------
    X : data matrix of size [N, nb_var+1]
    Y : matrix containg values of the target variable of size [N, 1]
    theta : matrix containing the theta parameters of the linear model of size [1, nb_var+1]
    
    with N : number of elements and nb_var : number of predictor variables

    Returns
    -------
    loss : loss function value (mean square error)

    """

    #######################
    ##### To complete ##### 
    #######################

    return loss

def gradient_descent(X, Y, theta, alpha, nb_iters):
    """ Training to compute the linear regression parameters by gradient descent
    
    Parameters
    ----------
    X : data matrix of size [N, nb_var+1]
    Y : matrix containg values of the target variable of size [N, 1]
    theta : matrix containing the theta parameters of the linear model of size [1, nb_var+1]
    alpha : learning rate
    nb_iters : number of iterations
    
    with N : number of elements and nb_var : number of predictor variables


    Returns
    -------
    theta : matrix containing the theta parameters learnt by gradient descent of size [1, nb_var+1]
    J_history : list containg the loss function values for each iteration of length nb_iters


    """
    
    # Init of useful variables
    N = X.shape[0]
    J_history = np.zeros(nb_iters)

    for i in range(0, nb_iters):

        #######################
        ##### To complete ##### 
        #######################
        

    return theta, J_history

def display(X, Y, theta):
    """ Display in 2 dimensions of data points and of the linear regression curve defined by theta parameters
    

    Parameters
    ----------
    X : data matrix of size [N, nb_var+1]
    Y : matrix containg values of the target variable of size [N, 1]
    theta : matrix containing the theta parameters of the linear model of size [1, nb_var+1]
    
    with N : number of elements and nb_var : number of predictor variables

    Returns
    -------
    None

    """
    #######################
    ##### To complete ##### 
    #######################
    
    plt.show()


if __name__ == "__main__":

    # ===================== Part 1: Data loading and normalization =====================
    print("Data loading ...")

    X, Y, N, nb_var = read_data("food_truck.txt")
    # X, Y, N, nb_var = read_data("houses.txt")

    # Print of the ten first examples of the dataset
    print("Print of the ten first examples of the dataset : ")
    for i in range(0, 10):
        print(f"x = {X[i,:]}, y = {Y[i]}")

    # Normalization of variables 
    print("Normalization of variables  ...")

    X, mu, sigma = normalization(X)

    # Add one column of 1 values to X (for theta 0)
    X = np.hstack((np.ones((N,1)), X)) 

    # ===================== Part 2: Gradient descent =====================
    print("Training by gradient descent ...")

    # Choice of the learning rate and number of iterations
    alpha = 0.01
    nb_iters = 1500

    # Initialization of theta and call to the gradient descent function
    theta = np.zeros((1,nb_var+1))
    theta, J_history = gradient_descent(X, Y, theta, alpha, nb_iters)

    # Display of the loss function values obtained during gradient descent training
    plt.figure()
    plt.title("Loss function values obtained during gradient descent training")
    plt.plot(np.arange(J_history.size), J_history)
    plt.xlabel("Nomber of iterations")
    plt.ylabel("Loss function J")

    # Print of theta values
    print(f"Theta computed by gradient descent : {theta}")

    # In case of only one predictor variable, display the linear regression curve
    if nb_var == 1 :
        display(X,Y,theta)
    plt.show()

    print("Linear Regression completed.")
